%% Class egai
%% For The 3rd International Conference on Evolutionary Game Theory and Artificial Intelligence
%% EGAI v1.0

\ProvidesClass{assets/egai}[2025/06/10 v1.0 EGAI Conference Style]

\LoadClass[9pt,twocolumn]{extarticle}
\RequirePackage{times}
\RequirePackage{ifthen}
\RequirePackage[total={18.2cm,22.8cm},centering]{geometry}
\RequirePackage{scalefnt}
\RequirePackage{type1cm}
\RequirePackage{color}
\RequirePackage{graphicx}
\RequirePackage{fancyhdr}
\RequirePackage{cuted}
\RequirePackage{titlesec}
\RequirePackage{stfloats}
\RequirePackage{xcolor}

%% Set Nature-style line spacing globally
\renewcommand{\baselinestretch}{0.95}
\setlength{\parskip}{0pt} % No extra space between paragraphs

% \definecolor{egai-green0}{rgb}{0.21176470588235294, 0.4549019607843137, 0.4549019607843137}
\definecolor{egai-blue1}{HTML}{3E5BB2}

%% Setup fancy headers for conference name and logo
\pagestyle{fancy}
\fancyhf{} % Clear all header and footer fields
\fancyfoot[C]{\thepage} % Add page number to the footer center
\fancyhead[L]{\raisebox{0pt}{\fontsize{10}{10}\selectfont The 3rd International Conference on Evolutionary Game Theory and Artificial Intelligence}}
\fancyhead[R]{\raisebox{-5pt}{\includegraphics[height=35pt]{assets/logo.png}}} % Logo moved up
\renewcommand{\headrulewidth}{0pt} % Remove default header rule
\renewcommand{\headrule}{{\color{egai-blue1}\rule{\textwidth}{2pt}}} % Add blue line as header rule
\setlength{\headheight}{53pt} % Increased header height to accommodate logo position and blue line
\addtolength{\topmargin}{-15pt}

%% Apply fancy header to first page as well
\fancypagestyle{plain}{%
    \fancyhf{}
    \fancyfoot[C]{\thepage} % Add page number to the footer center
    \fancyhead[L]{\raisebox{0pt}{\fontsize{9}{10}\selectfont\sffamily The 3rd International Conference on Evolutionary Game Theory and Artificial Intelligence}}
    \fancyhead[R]{\raisebox{-5pt}{\includegraphics[height=35pt]{logo.png}}} % Logo moved up
    \renewcommand{\headrulewidth}{0pt} % Remove default header rule
    \renewcommand{\headrule}{{\color{egai-blue1}\rule{\textwidth}{2pt}}} % Add blue line as header rule
}

%% Use natbib for better bibliography handling
\RequirePackage[super,sort&compress,comma]{natbib}

%% Customize natbib settings for EGAI style
\setcitestyle{super,open={},close={}}

%% make labels in bibliobraphy be #.
\renewcommand\@biblabel[1]{#1.}

%% Some style parameters
\setlength{\parindent}{0.20in}
\newcommand{\spacing}[1]{\renewcommand{\baselinestretch}{#1}\large\normalsize}

%% Corresponding author email
\def\correspondingemail#1{\gdef\@correspondingemail{#1}}
\gdef\@correspondingemail{}

%% Author handling system - Simple dynamic implementation for any number of authors
\RequirePackage{etoolbox}
\newcounter{authorcount}
\setcounter{authorcount}{0}

%% Storage for all author names in a token list
\newtoks\@authorlist
\@authorlist{}

%% Add author to the token list
\def\@addtoauthorlist#1{%
    \stepcounter{authorcount}%
    \global\@authorlist\expandafter{\the\@authorlist#1\@authorsep}%
}

%% Internal separator marker
\def\@authorsep{\@AUTHORSEP@}

%% Format the complete author list with proper punctuation
\def\@formatauthorlist{%
    \ifnum\value{authorcount}=0%
        % No authors
    \else\ifnum\value{authorcount}=1%
        % Single author - remove the separator
        \expandafter\@removelastsep\the\@authorlist\@nil%
    \else\ifnum\value{authorcount}=2%
        % Two authors - format as "A and B"
        \expandafter\@formattwosimple\the\@authorlist\@nil%
    \else%
        % Multiple authors - format as "A, B, and C"  
        \expandafter\@formatmanysimple\the\@authorlist\@nil%
    \fi\fi\fi%
}

%% Remove last separator for single author
\def\@removelastsep#1\@authorsep\@nil{#1}

%% Format two authors
\def\@formattwosimple#1\@authorsep#2\@authorsep\@nil{#1 and #2}

%% Format multiple authors with Oxford comma
\def\@formatmanysimple#1\@nil{%
    \@convertseps#1\@nil%
}

%% Convert separators to commas and handle final "and"
\def\@convertseps#1\@authorsep#2\@nil{%
    \ifx\@empty#2\@empty%
        % No separator found, just output the text (shouldn't happen)
        #1%
    \else%
        % Check if there's another separator after this one
        \@checkanothersep#2\@nil%
        \ifx\@nextsep\@empty%
            % This is the last separator, replace with ", and "
            #1, and \@removelastsep#2\@nil%
        \else%
            % More separators follow, replace with comma and continue
            #1, \@convertseps#2\@nil%
        \fi%
    \fi%
}

%% Check if there's another separator in the remaining text
\def\@checkanothersep#1\@authorsep#2\@nil{%
    \ifx\@empty#2\@empty%
        \def\@nextsep{}%
    \else%
        \def\@nextsep{found}%
    \fi%
}

%% Define \author*[affiliations]{name} for corresponding authors
\def\author@star[#1]#2{%
    \@addtoauthorlist{#2\textsuperscript{#1*}}%
}

%% Define \author[affiliations]{name} for regular authors
\def\author@nostar[#1]#2{%
    \@addtoauthorlist{#2\textsuperscript{#1}}%
}

%% Check for * and route to appropriate command
\def\author{\@ifstar\author@star\author@nostar}

%% Override the default \@author to use our dynamic author list
\def\@author{%
    \@formatauthorlist%
}

%% Redefine \maketitle for Nature style
\def\@maketitle{%
    \vspace*{-0.5cm}% Remove the extra space above the title
  \newpage\spacing{0.95}\setlength{\parskip}{3pt}%
    {\scalefont{2.7}\noindent\sloppy%
        \begin{flushleft}\sffamily\bfseries\@title\end{flushleft} \par\vspace{0.4cm}}%
    {\scalefont{1.1}\noindent\sffamily\bfseries\sloppy \@author \par \vspace{-0.1cm}}% % 0.3cm -> -0.1cm
    \noindent\rule{\textwidth}{0.4pt}\par\vspace{-0.2cm}% % 0.3cm -> -0.2cm
    % Ensure compact line spacing for main text following Nature style
    \spacing{0.95}%
}

%% Redefine maketitle to add affiliations after the title
\def\maketitle{%
    \par%
    \begingroup%
        \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
        \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
        \long\def\@makefntext##1{\parindent 1em\noindent%
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
        \if@twocolumn%
            \ifnum \col@number=\@ne%
                \@maketitle%
            \else%
                \twocolumn[\@maketitle]%
            \fi%
        \else%
            \newpage%
            \global\@topnum\z@%
            \@maketitle%
        \fi%
        \thispagestyle{fancy}%
        \@thanks%
    \endgroup%
    \setcounter{footnote}{0}%
    \global\let\thanks\relax%
    \global\let\maketitle\relax%
    \global\let\@maketitle\relax%
    \global\let\@thanks\@empty%
    \global\let\@author\@empty%
    \global\let\@date\@empty%
    \global\let\@title\@empty%
    \global\let\title\relax%
    \global\let\author\relax%
    \global\let\date\relax%
    \global\let\and\relax%
    % Display affiliations if defined using \affiliation command
    \@displayaffiliations%
}

%% Affiliation system - support both new \affiliation command and legacy affiliations environment
\newtoks\theaffils
\newcounter{affilcount}
\newif\ifaffiliationsdefined
\affiliationsdefinedfalse

%% New \affiliation[num]{text} command - can be used before \begin{document}
\def\affiliation[#1]#2{%
    \global\affiliationsdefinedtrue%
    \expandafter\gdef\csname @affiliation@#1\endcsname{#2}%
    % Keep track of the highest affiliation number
    \ifnum#1>\value{affilcount}%
        \setcounter{affilcount}{#1}%
    \fi%
}

%% Command to format all defined affiliations
\def\@formataffiliations{%
    \theaffils{}%
    \@tempcnta=1%
    \loop%
        \ifcsname @affiliation@\the\@tempcnta\endcsname%
            \expandafter\theaffils\expandafter{\the\theaffils \textsuperscript{\the\@tempcnta}\csname @affiliation@\the\@tempcnta\endcsname\quad}%
        \fi%
        \advance\@tempcnta by 1%
        \ifnum\@tempcnta>\value{affilcount}%
        \else%
            \repeat%
}

%% Display affiliations at bottom of page
\def\@displayaffiliations{%
    \ifaffiliationsdefined%
        \@formataffiliations%
        \begin{figure*}[b]%
            \noindent\rule{\textwidth}{0.4pt}\par\vspace{2pt}%
            \noindent\sffamily\scalefont{0.83}\the\theaffils
            \ifx\@correspondingemail\empty\else\par\vspace{2pt}\noindent\sffamily\scalefont{1.0}{*Email(s): \@correspondingemail}\fi%
        \end{figure*}%
    \fi%
}

%% Legacy affiliations environment for backward compatibility
\newenvironment{affiliations}{%
    \theaffils{}%
    \setcounter{affilcount}{0}%
    \def\item##1{%
        \stepcounter{affilcount}%
        \expandafter\theaffils\expandafter{\the\theaffils \textsuperscript{\arabic{affilcount}}##1\quad}%
    }%
}{%
    \begin{figure*}[b]%
        \noindent\rule{\textwidth}{0.4pt}\par\vspace{2pt}%
        \noindent\sffamily\scalefont{0.83}\the\theaffils
        \ifx\@correspondingemail\empty\else\par\vspace{2pt}\noindent\sffamily\scalefont{1.0}{*Email(s): \@correspondingemail}\fi%
    \end{figure*}%
}

%% Redefine the abstract environment to be the first bold paragraph
\renewenvironment{abstract}{%
  \begin{strip}
    % Set Nature-style compact line spacing for abstract
    \renewcommand{\baselinestretch}{1.05}%
    % Remove paragraph indentation
    \setlength{\parindent}{0pt}%
    % Set paragraph spacing (0pt for no spacing between paragraphs)
    % To add spacing between paragraphs, use e.g. 0.5\baselineskip
    \setlength{\parskip}{0pt}%
    % Remove any extra left/right indentation
    \setlength{\leftskip}{0pt}%
    \setlength{\rightskip}{0.15\textwidth}%
    % Ensure first paragraph has no indentation
    \noindent\sffamily\scalefont{1.1}\ignorespaces
}{%
\vspace{1.0\baselineskip}% Add extra space between abstract and main text
  \end{strip}
}

%% Sectioning Commands
\setcounter{secnumdepth}{0} % 1. Remove numbering for all sections

% Section: no number, no indent on first paragraph
\titleformat{\section}
  {\sffamily\bfseries\scalefont{1.3}}% format
  {}% label
  {0em}% sep
  {}% before-code
\titlespacing*{\section}
  {0pt}% left
  {12pt}% before-sep
  {6pt}% after-sep

% Subsection: no number, no indent on first paragraph
\titleformat{\subsection}
  {\sffamily\bfseries\scalefont{1.1}}% format
  {}% label
  {0em}% sep
  {}% before-code
\titlespacing*{\subsection}
  {0pt}% left
  {8pt}% before-sep
  {4pt}% after-sep

% Subsubsection: no number, run-in title
\titleformat{\subsubsection}[runin]
  {\normalfont\bfseries}% format
  {}% label
  {0em}% sep
  {}% before-code
  [.]% after-title
\titlespacing{\subsubsection}
  {0pt}% left
  {6pt}% before-sep
  {1em}% after-sep (space after title)



%% No heading for References section, but eat up the extra space from \section command
\renewcommand\refname{}

%% Customize bibliography formatting for natbib
\renewcommand{\bibfont}{\sffamily\scalefont{0.83}}
\setlength{\bibsep}{1pt}

%% For manual bibliography compatibility
\let\oldthebibliography=\thebibliography
\let\endoldthebibliography=\endthebibliography
\renewenvironment{thebibliography}[1]{%
  \begin{oldthebibliography}{#1}%
    \sffamily%
    \renewcommand{\baselinestretch}{1.0}%
    \scalefont{0.83}%
    \setlength{\parskip}{1pt}%
}%
{%
  \end{oldthebibliography}%
}

\let\oldbibitem=\bibitem
\renewcommand{\bibitem}[1]{\vspace{-0.15ex}\oldbibitem{#1}}

%% Define the addendum environment for Supplementary Info, Acknowledgements, etc.
\newenvironment{addendum}{%
    \setlength{\parindent}{0in}%
    \sffamily%
    \scalefont{0.83}%
    \begin{list}{Acknowledgements}{%
        \setlength{\leftmargin}{0in}%
        \setlength{\listparindent}{0in}%
        \setlength{\labelsep}{0em}%
        \setlength{\labelwidth}{0in}%
        \setlength{\itemsep}{5pt}%
        \let\makelabel\addendumlabel}
    }
    {\end{list}\par\vfill}

\newcommand*{\addendumlabel}[1]{\textbf{#1}\hspace{1em}}

%% Figures and tables:
%% The \includegraphics command is respected.
%% Tables should all be moved to the end of the document
%% manually.

\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{Table}

%% Change the way captions are formatted. Based on a tip by Jakob Schiotz.
%% http://dcwww.camd.dtu.dk/~schiotz/comp/LatexTips/LatexTips.html
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{{\textbf{\scalefont{0.93}#1 $\vert$}} \scalefont{0.93}#2}%
  \ifdim \wd\@tempboxa >\hsize
    {\scalefont{0.93}{\textbf{\scalefont{0.93}#1 $\vert$}} \scalefont{0.93}#2\par}
  \else
    \hbox to\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
